/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.Column;
import software.amazon.awssdk.services.glue.model.ColumnListCopier;
import software.amazon.awssdk.services.glue.model.ParametersMapCopier;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.transform.TableMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Table
implements StructuredPojo,
ToCopyableBuilder<Builder, Table> {
    private final String name;
    private final String databaseName;
    private final String description;
    private final String owner;
    private final Instant createTime;
    private final Instant updateTime;
    private final Instant lastAccessTime;
    private final Instant lastAnalyzedTime;
    private final Integer retention;
    private final StorageDescriptor storageDescriptor;
    private final List<Column> partitionKeys;
    private final String viewOriginalText;
    private final String viewExpandedText;
    private final String tableType;
    private final Map<String, String> parameters;
    private final String createdBy;

    private Table(BuilderImpl builder) {
        this.name = builder.name;
        this.databaseName = builder.databaseName;
        this.description = builder.description;
        this.owner = builder.owner;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.lastAccessTime = builder.lastAccessTime;
        this.lastAnalyzedTime = builder.lastAnalyzedTime;
        this.retention = builder.retention;
        this.storageDescriptor = builder.storageDescriptor;
        this.partitionKeys = builder.partitionKeys;
        this.viewOriginalText = builder.viewOriginalText;
        this.viewExpandedText = builder.viewExpandedText;
        this.tableType = builder.tableType;
        this.parameters = builder.parameters;
        this.createdBy = builder.createdBy;
    }

    public String name() {
        return this.name;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String description() {
        return this.description;
    }

    public String owner() {
        return this.owner;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Instant updateTime() {
        return this.updateTime;
    }

    public Instant lastAccessTime() {
        return this.lastAccessTime;
    }

    public Instant lastAnalyzedTime() {
        return this.lastAnalyzedTime;
    }

    public Integer retention() {
        return this.retention;
    }

    public StorageDescriptor storageDescriptor() {
        return this.storageDescriptor;
    }

    public List<Column> partitionKeys() {
        return this.partitionKeys;
    }

    public String viewOriginalText() {
        return this.viewOriginalText;
    }

    public String viewExpandedText() {
        return this.viewExpandedText;
    }

    public String tableType() {
        return this.tableType;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAccessTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAnalyzedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.retention());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageDescriptor());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewOriginalText());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewExpandedText());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableType());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Table)) {
            return false;
        }
        Table other = (Table)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.lastAccessTime(), other.lastAccessTime()) && Objects.equals(this.lastAnalyzedTime(), other.lastAnalyzedTime()) && Objects.equals(this.retention(), other.retention()) && Objects.equals(this.storageDescriptor(), other.storageDescriptor()) && Objects.equals(this.partitionKeys(), other.partitionKeys()) && Objects.equals(this.viewOriginalText(), other.viewOriginalText()) && Objects.equals(this.viewExpandedText(), other.viewExpandedText()) && Objects.equals(this.tableType(), other.tableType()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.createdBy(), other.createdBy());
    }

    public String toString() {
        return ToString.builder((String)"Table").add("Name", (Object)this.name()).add("DatabaseName", (Object)this.databaseName()).add("Description", (Object)this.description()).add("Owner", (Object)this.owner()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("LastAccessTime", (Object)this.lastAccessTime()).add("LastAnalyzedTime", (Object)this.lastAnalyzedTime()).add("Retention", (Object)this.retention()).add("StorageDescriptor", (Object)this.storageDescriptor()).add("PartitionKeys", this.partitionKeys()).add("ViewOriginalText", (Object)this.viewOriginalText()).add("ViewExpandedText", (Object)this.viewExpandedText()).add("TableType", (Object)this.tableType()).add("Parameters", this.parameters()).add("CreatedBy", (Object)this.createdBy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "DatabaseName": {
                return Optional.of(clazz.cast(this.databaseName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Owner": {
                return Optional.of(clazz.cast(this.owner()));
            }
            case "CreateTime": {
                return Optional.of(clazz.cast(this.createTime()));
            }
            case "UpdateTime": {
                return Optional.of(clazz.cast(this.updateTime()));
            }
            case "LastAccessTime": {
                return Optional.of(clazz.cast(this.lastAccessTime()));
            }
            case "LastAnalyzedTime": {
                return Optional.of(clazz.cast(this.lastAnalyzedTime()));
            }
            case "Retention": {
                return Optional.of(clazz.cast(this.retention()));
            }
            case "StorageDescriptor": {
                return Optional.of(clazz.cast(this.storageDescriptor()));
            }
            case "PartitionKeys": {
                return Optional.of(clazz.cast(this.partitionKeys()));
            }
            case "ViewOriginalText": {
                return Optional.of(clazz.cast(this.viewOriginalText()));
            }
            case "ViewExpandedText": {
                return Optional.of(clazz.cast(this.viewExpandedText()));
            }
            case "TableType": {
                return Optional.of(clazz.cast(this.tableType()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "CreatedBy": {
                return Optional.of(clazz.cast(this.createdBy()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TableMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String databaseName;
        private String description;
        private String owner;
        private Instant createTime;
        private Instant updateTime;
        private Instant lastAccessTime;
        private Instant lastAnalyzedTime;
        private Integer retention;
        private StorageDescriptor storageDescriptor;
        private List<Column> partitionKeys;
        private String viewOriginalText;
        private String viewExpandedText;
        private String tableType;
        private Map<String, String> parameters;
        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(Table model) {
            this.name(model.name);
            this.databaseName(model.databaseName);
            this.description(model.description);
            this.owner(model.owner);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.lastAccessTime(model.lastAccessTime);
            this.lastAnalyzedTime(model.lastAnalyzedTime);
            this.retention(model.retention);
            this.storageDescriptor(model.storageDescriptor);
            this.partitionKeys(model.partitionKeys);
            this.viewOriginalText(model.viewOriginalText);
            this.viewExpandedText(model.viewExpandedText);
            this.tableType(model.tableType);
            this.parameters(model.parameters);
            this.createdBy(model.createdBy);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public final Instant getLastAccessTime() {
            return this.lastAccessTime;
        }

        @Override
        public final Builder lastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
            return this;
        }

        public final void setLastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }

        public final Instant getLastAnalyzedTime() {
            return this.lastAnalyzedTime;
        }

        @Override
        public final Builder lastAnalyzedTime(Instant lastAnalyzedTime) {
            this.lastAnalyzedTime = lastAnalyzedTime;
            return this;
        }

        public final void setLastAnalyzedTime(Instant lastAnalyzedTime) {
            this.lastAnalyzedTime = lastAnalyzedTime;
        }

        public final Integer getRetention() {
            return this.retention;
        }

        @Override
        public final Builder retention(Integer retention) {
            this.retention = retention;
            return this;
        }

        public final void setRetention(Integer retention) {
            this.retention = retention;
        }

        public final StorageDescriptor.Builder getStorageDescriptor() {
            return this.storageDescriptor != null ? this.storageDescriptor.toBuilder() : null;
        }

        @Override
        public final Builder storageDescriptor(StorageDescriptor storageDescriptor) {
            this.storageDescriptor = storageDescriptor;
            return this;
        }

        public final void setStorageDescriptor(StorageDescriptor.BuilderImpl storageDescriptor) {
            this.storageDescriptor = storageDescriptor != null ? storageDescriptor.build() : null;
        }

        public final Collection<Column.Builder> getPartitionKeys() {
            return this.partitionKeys != null ? (Collection)this.partitionKeys.stream().map(Column::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partitionKeys(Collection<Column> partitionKeys) {
            this.partitionKeys = ColumnListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKeys(Column ... partitionKeys) {
            this.partitionKeys(Arrays.asList(partitionKeys));
            return this;
        }

        public final void setPartitionKeys(Collection<Column.BuilderImpl> partitionKeys) {
            this.partitionKeys = ColumnListCopier.copyFromBuilder(partitionKeys);
        }

        public final String getViewOriginalText() {
            return this.viewOriginalText;
        }

        @Override
        public final Builder viewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
            return this;
        }

        public final void setViewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
        }

        public final String getViewExpandedText() {
            return this.viewExpandedText;
        }

        @Override
        public final Builder viewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
            return this;
        }

        public final void setViewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
        }

        public final String getTableType() {
            return this.tableType;
        }

        @Override
        public final Builder tableType(String tableType) {
            this.tableType = tableType;
            return this;
        }

        public final void setTableType(String tableType) {
            this.tableType = tableType;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public Table build() {
            return new Table(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Table> {
        public Builder name(String var1);

        public Builder databaseName(String var1);

        public Builder description(String var1);

        public Builder owner(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder lastAccessTime(Instant var1);

        public Builder lastAnalyzedTime(Instant var1);

        public Builder retention(Integer var1);

        public Builder storageDescriptor(StorageDescriptor var1);

        default public Builder storageDescriptor(Consumer<StorageDescriptor.Builder> storageDescriptor) {
            return this.storageDescriptor((StorageDescriptor)((StorageDescriptor.Builder)StorageDescriptor.builder().apply(storageDescriptor)).build());
        }

        public Builder partitionKeys(Collection<Column> var1);

        public Builder partitionKeys(Column ... var1);

        public Builder viewOriginalText(String var1);

        public Builder viewExpandedText(String var1);

        public Builder tableType(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder createdBy(String var1);
    }
}

