/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.Condition;
import software.amazon.awssdk.services.glue.model.ConditionListCopier;
import software.amazon.awssdk.services.glue.model.Logical;
import software.amazon.awssdk.services.glue.transform.PredicateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Predicate
implements StructuredPojo,
ToCopyableBuilder<Builder, Predicate> {
    private final String logical;
    private final List<Condition> conditions;

    private Predicate(BuilderImpl builder) {
        this.logical = builder.logical;
        this.conditions = builder.conditions;
    }

    public Logical logical() {
        return Logical.fromValue(this.logical);
    }

    public String logicalString() {
        return this.logical;
    }

    public List<Condition> conditions() {
        return this.conditions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate)obj;
        return Objects.equals(this.logicalString(), other.logicalString()) && Objects.equals(this.conditions(), other.conditions());
    }

    public String toString() {
        return ToString.builder((String)"Predicate").add("Logical", (Object)this.logicalString()).add("Conditions", this.conditions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Logical": {
                return Optional.of(clazz.cast(this.logicalString()));
            }
            case "Conditions": {
                return Optional.of(clazz.cast(this.conditions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PredicateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String logical;
        private List<Condition> conditions;

        private BuilderImpl() {
        }

        private BuilderImpl(Predicate model) {
            this.logical(model.logical);
            this.conditions(model.conditions);
        }

        public final String getLogical() {
            return this.logical;
        }

        @Override
        public final Builder logical(String logical) {
            this.logical = logical;
            return this;
        }

        @Override
        public final Builder logical(Logical logical) {
            this.logical(logical.toString());
            return this;
        }

        public final void setLogical(String logical) {
            this.logical = logical;
        }

        public final Collection<Condition.Builder> getConditions() {
            return this.conditions != null ? (Collection)this.conditions.stream().map(Condition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conditions(Collection<Condition> conditions) {
            this.conditions = ConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Condition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        public final void setConditions(Collection<Condition.BuilderImpl> conditions) {
            this.conditions = ConditionListCopier.copyFromBuilder(conditions);
        }

        public Predicate build() {
            return new Predicate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Predicate> {
        public Builder logical(String var1);

        public Builder logical(Logical var1);

        public Builder conditions(Collection<Condition> var1);

        public Builder conditions(Condition ... var1);
    }
}

