/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDevEndpointResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, CreateDevEndpointResponse> {
    private final String endpointName;
    private final String status;
    private final List<String> securityGroupIds;
    private final String subnetId;
    private final String roleArn;
    private final String yarnEndpointAddress;
    private final Integer zeppelinRemoteSparkInterpreterPort;
    private final Integer numberOfNodes;
    private final String availabilityZone;
    private final String vpcId;
    private final String extraPythonLibsS3Path;
    private final String extraJarsS3Path;
    private final String failureReason;
    private final Instant createdTimestamp;

    private CreateDevEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.status = builder.status;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.roleArn = builder.roleArn;
        this.yarnEndpointAddress = builder.yarnEndpointAddress;
        this.zeppelinRemoteSparkInterpreterPort = builder.zeppelinRemoteSparkInterpreterPort;
        this.numberOfNodes = builder.numberOfNodes;
        this.availabilityZone = builder.availabilityZone;
        this.vpcId = builder.vpcId;
        this.extraPythonLibsS3Path = builder.extraPythonLibsS3Path;
        this.extraJarsS3Path = builder.extraJarsS3Path;
        this.failureReason = builder.failureReason;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public String status() {
        return this.status;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String yarnEndpointAddress() {
        return this.yarnEndpointAddress;
    }

    public Integer zeppelinRemoteSparkInterpreterPort() {
        return this.zeppelinRemoteSparkInterpreterPort;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String extraPythonLibsS3Path() {
        return this.extraPythonLibsS3Path;
    }

    public String extraJarsS3Path() {
        return this.extraJarsS3Path;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.yarnEndpointAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.zeppelinRemoteSparkInterpreterPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraPythonLibsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraJarsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDevEndpointResponse)) {
            return false;
        }
        CreateDevEndpointResponse other = (CreateDevEndpointResponse)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.yarnEndpointAddress(), other.yarnEndpointAddress()) && Objects.equals(this.zeppelinRemoteSparkInterpreterPort(), other.zeppelinRemoteSparkInterpreterPort()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.extraPythonLibsS3Path(), other.extraPythonLibsS3Path()) && Objects.equals(this.extraJarsS3Path(), other.extraJarsS3Path()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"CreateDevEndpointResponse").add("EndpointName", (Object)this.endpointName()).add("Status", (Object)this.status()).add("SecurityGroupIds", this.securityGroupIds()).add("SubnetId", (Object)this.subnetId()).add("RoleArn", (Object)this.roleArn()).add("YarnEndpointAddress", (Object)this.yarnEndpointAddress()).add("ZeppelinRemoteSparkInterpreterPort", (Object)this.zeppelinRemoteSparkInterpreterPort()).add("NumberOfNodes", (Object)this.numberOfNodes()).add("AvailabilityZone", (Object)this.availabilityZone()).add("VpcId", (Object)this.vpcId()).add("ExtraPythonLibsS3Path", (Object)this.extraPythonLibsS3Path()).add("ExtraJarsS3Path", (Object)this.extraJarsS3Path()).add("FailureReason", (Object)this.failureReason()).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.of(clazz.cast(this.endpointName()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "RoleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "YarnEndpointAddress": {
                return Optional.of(clazz.cast(this.yarnEndpointAddress()));
            }
            case "ZeppelinRemoteSparkInterpreterPort": {
                return Optional.of(clazz.cast(this.zeppelinRemoteSparkInterpreterPort()));
            }
            case "NumberOfNodes": {
                return Optional.of(clazz.cast(this.numberOfNodes()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "ExtraPythonLibsS3Path": {
                return Optional.of(clazz.cast(this.extraPythonLibsS3Path()));
            }
            case "ExtraJarsS3Path": {
                return Optional.of(clazz.cast(this.extraJarsS3Path()));
            }
            case "FailureReason": {
                return Optional.of(clazz.cast(this.failureReason()));
            }
            case "CreatedTimestamp": {
                return Optional.of(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String endpointName;
        private String status;
        private List<String> securityGroupIds;
        private String subnetId;
        private String roleArn;
        private String yarnEndpointAddress;
        private Integer zeppelinRemoteSparkInterpreterPort;
        private Integer numberOfNodes;
        private String availabilityZone;
        private String vpcId;
        private String extraPythonLibsS3Path;
        private String extraJarsS3Path;
        private String failureReason;
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDevEndpointResponse model) {
            this.endpointName(model.endpointName);
            this.status(model.status);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetId(model.subnetId);
            this.roleArn(model.roleArn);
            this.yarnEndpointAddress(model.yarnEndpointAddress);
            this.zeppelinRemoteSparkInterpreterPort(model.zeppelinRemoteSparkInterpreterPort);
            this.numberOfNodes(model.numberOfNodes);
            this.availabilityZone(model.availabilityZone);
            this.vpcId(model.vpcId);
            this.extraPythonLibsS3Path(model.extraPythonLibsS3Path);
            this.extraJarsS3Path(model.extraJarsS3Path);
            this.failureReason(model.failureReason);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getYarnEndpointAddress() {
            return this.yarnEndpointAddress;
        }

        @Override
        public final Builder yarnEndpointAddress(String yarnEndpointAddress) {
            this.yarnEndpointAddress = yarnEndpointAddress;
            return this;
        }

        public final void setYarnEndpointAddress(String yarnEndpointAddress) {
            this.yarnEndpointAddress = yarnEndpointAddress;
        }

        public final Integer getZeppelinRemoteSparkInterpreterPort() {
            return this.zeppelinRemoteSparkInterpreterPort;
        }

        @Override
        public final Builder zeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort) {
            this.zeppelinRemoteSparkInterpreterPort = zeppelinRemoteSparkInterpreterPort;
            return this;
        }

        public final void setZeppelinRemoteSparkInterpreterPort(Integer zeppelinRemoteSparkInterpreterPort) {
            this.zeppelinRemoteSparkInterpreterPort = zeppelinRemoteSparkInterpreterPort;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getExtraPythonLibsS3Path() {
            return this.extraPythonLibsS3Path;
        }

        @Override
        public final Builder extraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
            return this;
        }

        public final void setExtraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
        }

        public final String getExtraJarsS3Path() {
            return this.extraJarsS3Path;
        }

        @Override
        public final Builder extraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
            return this;
        }

        public final void setExtraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public CreateDevEndpointResponse build() {
            return new CreateDevEndpointResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, CreateDevEndpointResponse> {
        public Builder endpointName(String var1);

        public Builder status(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetId(String var1);

        public Builder roleArn(String var1);

        public Builder yarnEndpointAddress(String var1);

        public Builder zeppelinRemoteSparkInterpreterPort(Integer var1);

        public Builder numberOfNodes(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder vpcId(String var1);

        public Builder extraPythonLibsS3Path(String var1);

        public Builder extraJarsS3Path(String var1);

        public Builder failureReason(String var1);

        public Builder createdTimestamp(Instant var1);
    }
}

