/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.JobRunState;
import software.amazon.awssdk.services.glue.model.LogicalOperator;
import software.amazon.awssdk.services.glue.transform.ConditionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Condition
implements StructuredPojo,
ToCopyableBuilder<Builder, Condition> {
    private final String logicalOperator;
    private final String jobName;
    private final String state;

    private Condition(BuilderImpl builder) {
        this.logicalOperator = builder.logicalOperator;
        this.jobName = builder.jobName;
        this.state = builder.state;
    }

    public LogicalOperator logicalOperator() {
        return LogicalOperator.fromValue(this.logicalOperator);
    }

    public String logicalOperatorString() {
        return this.logicalOperator;
    }

    public String jobName() {
        return this.jobName;
    }

    public JobRunState state() {
        return JobRunState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalOperatorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)obj;
        return Objects.equals(this.logicalOperatorString(), other.logicalOperatorString()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.stateString(), other.stateString());
    }

    public String toString() {
        return ToString.builder((String)"Condition").add("LogicalOperator", (Object)this.logicalOperatorString()).add("JobName", (Object)this.jobName()).add("State", (Object)this.stateString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogicalOperator": {
                return Optional.of(clazz.cast(this.logicalOperatorString()));
            }
            case "JobName": {
                return Optional.of(clazz.cast(this.jobName()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConditionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String logicalOperator;
        private String jobName;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            this.logicalOperator(model.logicalOperator);
            this.jobName(model.jobName);
            this.state(model.state);
        }

        public final String getLogicalOperator() {
            return this.logicalOperator;
        }

        @Override
        public final Builder logicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
            return this;
        }

        @Override
        public final Builder logicalOperator(LogicalOperator logicalOperator) {
            this.logicalOperator(logicalOperator.toString());
            return this;
        }

        public final void setLogicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JobRunState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public Condition build() {
            return new Condition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Condition> {
        public Builder logicalOperator(String var1);

        public Builder logicalOperator(LogicalOperator var1);

        public Builder jobName(String var1);

        public Builder state(String var1);

        public Builder state(JobRunState var1);
    }
}

