/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateTableRequestModelMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TABLEINPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableInput").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SKIPARCHIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkipArchive").isBinary(false).build();
    private static final UpdateTableRequestModelMarshaller INSTANCE = new UpdateTableRequestModelMarshaller();

    private UpdateTableRequestModelMarshaller() {
    }

    public static UpdateTableRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateTableRequest updateTableRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateTableRequest), (String)"updateTableRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateTableRequest.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)updateTableRequest.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)updateTableRequest.tableInput(), TABLEINPUT_BINDING);
            protocolMarshaller.marshall((Object)updateTableRequest.skipArchive(), SKIPARCHIVE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

