/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.TableVersionError;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TableVersionErrorMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ERRORDETAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorDetail").isBinary(false).build();
    private static final TableVersionErrorMarshaller INSTANCE = new TableVersionErrorMarshaller();

    private TableVersionErrorMarshaller() {
    }

    public static TableVersionErrorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TableVersionError tableVersionError, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)tableVersionError, (String)"tableVersionError");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)tableVersionError.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)tableVersionError.versionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)tableVersionError.errorDetail(), ERRORDETAIL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

