/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.SecurityConfiguration;
import software.amazon.awssdk.services.glue.transform.EncryptionConfigurationUnmarshaller;

public class SecurityConfigurationUnmarshaller
implements Unmarshaller<SecurityConfiguration, JsonUnmarshallerContext> {
    private static final SecurityConfigurationUnmarshaller INSTANCE = new SecurityConfigurationUnmarshaller();

    public SecurityConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        SecurityConfiguration.Builder securityConfigurationBuilder = SecurityConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    securityConfigurationBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatedTimeStamp", targetDepth)) {
                    context.nextToken();
                    securityConfigurationBuilder.createdTimeStamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("EncryptionConfiguration", targetDepth)) {
                    context.nextToken();
                    securityConfigurationBuilder.encryptionConfiguration(EncryptionConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SecurityConfiguration)securityConfigurationBuilder.build();
    }

    public static SecurityConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

