/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.S3Target;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3TargetMarshaller {
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Path").isBinary(false).build();
    private static final MarshallingInfo<List> EXCLUSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Exclusions").isBinary(false).build();
    private static final S3TargetMarshaller INSTANCE = new S3TargetMarshaller();

    private S3TargetMarshaller() {
    }

    public static S3TargetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3Target s3Target, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3Target, (String)"s3Target");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3Target.path(), PATH_BINDING);
            protocolMarshaller.marshall(s3Target.exclusions(), EXCLUSIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

