/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.S3Encryption;

public class S3EncryptionUnmarshaller
implements Unmarshaller<S3Encryption, JsonUnmarshallerContext> {
    private static final S3EncryptionUnmarshaller INSTANCE = new S3EncryptionUnmarshaller();

    public S3Encryption unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Encryption.Builder s3EncryptionBuilder = S3Encryption.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("S3EncryptionMode", targetDepth)) {
                    context.nextToken();
                    s3EncryptionBuilder.s3EncryptionMode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KmsKeyArn", targetDepth)) {
                    context.nextToken();
                    s3EncryptionBuilder.kmsKeyArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (S3Encryption)s3EncryptionBuilder.build();
    }

    public static S3EncryptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

