/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.S3Encryption;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3EncryptionMarshaller {
    private static final MarshallingInfo<String> S3ENCRYPTIONMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3EncryptionMode").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyArn").isBinary(false).build();
    private static final S3EncryptionMarshaller INSTANCE = new S3EncryptionMarshaller();

    private S3EncryptionMarshaller() {
    }

    public static S3EncryptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3Encryption s3Encryption, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3Encryption, (String)"s3Encryption");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3Encryption.s3EncryptionModeAsString(), S3ENCRYPTIONMODE_BINDING);
            protocolMarshaller.marshall((Object)s3Encryption.kmsKeyArn(), KMSKEYARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

