/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.Predecessor;

public class PredecessorUnmarshaller
implements Unmarshaller<Predecessor, JsonUnmarshallerContext> {
    private static final PredecessorUnmarshaller INSTANCE = new PredecessorUnmarshaller();

    public Predecessor unmarshall(JsonUnmarshallerContext context) throws Exception {
        Predecessor.Builder predecessorBuilder = Predecessor.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("JobName", targetDepth)) {
                    context.nextToken();
                    predecessorBuilder.jobName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RunId", targetDepth)) {
                    context.nextToken();
                    predecessorBuilder.runId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Predecessor)predecessorBuilder.build();
    }

    public static PredecessorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

