/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.PartitionValueList;

public class PartitionValueListUnmarshaller
implements Unmarshaller<PartitionValueList, JsonUnmarshallerContext> {
    private static final PartitionValueListUnmarshaller INSTANCE = new PartitionValueListUnmarshaller();

    public PartitionValueList unmarshall(JsonUnmarshallerContext context) throws Exception {
        PartitionValueList.Builder partitionValueListBuilder = PartitionValueList.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Values", targetDepth)) {
                    context.nextToken();
                    partitionValueListBuilder.values(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (PartitionValueList)partitionValueListBuilder.build();
    }

    public static PartitionValueListUnmarshaller getInstance() {
        return INSTANCE;
    }
}

