/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.Location;
import software.amazon.awssdk.services.glue.transform.CodeGenNodeArgUnmarshaller;

public class LocationUnmarshaller
implements Unmarshaller<Location, JsonUnmarshallerContext> {
    private static final LocationUnmarshaller INSTANCE = new LocationUnmarshaller();

    public Location unmarshall(JsonUnmarshallerContext context) throws Exception {
        Location.Builder locationBuilder = Location.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Jdbc", targetDepth)) {
                    context.nextToken();
                    locationBuilder.jdbc(new ListUnmarshaller((Unmarshaller)CodeGenNodeArgUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("S3", targetDepth)) {
                    context.nextToken();
                    locationBuilder.s3(new ListUnmarshaller((Unmarshaller)CodeGenNodeArgUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("DynamoDB", targetDepth)) {
                    context.nextToken();
                    locationBuilder.dynamoDB(new ListUnmarshaller((Unmarshaller)CodeGenNodeArgUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Location)locationBuilder.build();
    }

    public static LocationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

