/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.DynamoDBTarget;

public class DynamoDBTargetUnmarshaller
implements Unmarshaller<DynamoDBTarget, JsonUnmarshallerContext> {
    private static final DynamoDBTargetUnmarshaller INSTANCE = new DynamoDBTargetUnmarshaller();

    public DynamoDBTarget unmarshall(JsonUnmarshallerContext context) throws Exception {
        DynamoDBTarget.Builder dynamoDBTargetBuilder = DynamoDBTarget.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Path", targetDepth)) {
                    context.nextToken();
                    dynamoDBTargetBuilder.path((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DynamoDBTarget)dynamoDBTargetBuilder.build();
    }

    public static DynamoDBTargetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

