/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.ConnectionsList;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConnectionsListMarshaller {
    private static final MarshallingInfo<List> CONNECTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Connections").isBinary(false).build();
    private static final ConnectionsListMarshaller INSTANCE = new ConnectionsListMarshaller();

    private ConnectionsListMarshaller() {
    }

    public static ConnectionsListMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ConnectionsList connectionsList, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)connectionsList, (String)"connectionsList");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(connectionsList.connections(), CONNECTIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

