/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.CodeGenNode;
import software.amazon.awssdk.services.glue.transform.CodeGenNodeArgUnmarshaller;

public class CodeGenNodeUnmarshaller
implements Unmarshaller<CodeGenNode, JsonUnmarshallerContext> {
    private static final CodeGenNodeUnmarshaller INSTANCE = new CodeGenNodeUnmarshaller();

    public CodeGenNode unmarshall(JsonUnmarshallerContext context) throws Exception {
        CodeGenNode.Builder codeGenNodeBuilder = CodeGenNode.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    codeGenNodeBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NodeType", targetDepth)) {
                    context.nextToken();
                    codeGenNodeBuilder.nodeType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Args", targetDepth)) {
                    context.nextToken();
                    codeGenNodeBuilder.args(new ListUnmarshaller((Unmarshaller)CodeGenNodeArgUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("LineNumber", targetDepth)) {
                    context.nextToken();
                    codeGenNodeBuilder.lineNumber((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (CodeGenNode)codeGenNodeBuilder.build();
    }

    public static CodeGenNodeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

