/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.CloudWatchEncryption;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CloudWatchEncryptionMarshaller {
    private static final MarshallingInfo<String> CLOUDWATCHENCRYPTIONMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchEncryptionMode").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyArn").isBinary(false).build();
    private static final CloudWatchEncryptionMarshaller INSTANCE = new CloudWatchEncryptionMarshaller();

    private CloudWatchEncryptionMarshaller() {
    }

    public static CloudWatchEncryptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloudWatchEncryption cloudWatchEncryption, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cloudWatchEncryption, (String)"cloudWatchEncryption");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cloudWatchEncryption.cloudWatchEncryptionModeAsString(), CLOUDWATCHENCRYPTIONMODE_BINDING);
            protocolMarshaller.marshall((Object)cloudWatchEncryption.kmsKeyArn(), KMSKEYARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

