/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.transform.TableVersionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, TableVersion> {
    private final Table table;
    private final String versionId;

    private TableVersion(BuilderImpl builder) {
        this.table = builder.table;
        this.versionId = builder.versionId;
    }

    public Table table() {
        return this.table;
    }

    public String versionId() {
        return this.versionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableVersion)) {
            return false;
        }
        TableVersion other = (TableVersion)obj;
        return Objects.equals(this.table(), other.table()) && Objects.equals(this.versionId(), other.versionId());
    }

    public String toString() {
        return ToString.builder((String)"TableVersion").add("Table", (Object)this.table()).add("VersionId", (Object)this.versionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TableVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Table table;
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(TableVersion model) {
            this.table(model.table);
            this.versionId(model.versionId);
        }

        public final Table.Builder getTable() {
            return this.table != null ? this.table.toBuilder() : null;
        }

        @Override
        public final Builder table(Table table) {
            this.table = table;
            return this;
        }

        public final void setTable(Table.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public TableVersion build() {
            return new TableVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TableVersion> {
        public Builder table(Table var1);

        default public Builder table(Consumer<Table.Builder> table) {
            return this.table((Table)((Table.Builder)Table.builder().applyMutation(table)).build());
        }

        public Builder versionId(String var1);
    }
}

