/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ColumnValueStringListCopier;
import software.amazon.awssdk.services.glue.model.LocationMapCopier;
import software.amazon.awssdk.services.glue.model.NameStringListCopier;
import software.amazon.awssdk.services.glue.transform.SkewedInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SkewedInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, SkewedInfo> {
    private final List<String> skewedColumnNames;
    private final List<String> skewedColumnValues;
    private final Map<String, String> skewedColumnValueLocationMaps;

    private SkewedInfo(BuilderImpl builder) {
        this.skewedColumnNames = builder.skewedColumnNames;
        this.skewedColumnValues = builder.skewedColumnValues;
        this.skewedColumnValueLocationMaps = builder.skewedColumnValueLocationMaps;
    }

    public List<String> skewedColumnNames() {
        return this.skewedColumnNames;
    }

    public List<String> skewedColumnValues() {
        return this.skewedColumnValues;
    }

    public Map<String, String> skewedColumnValueLocationMaps() {
        return this.skewedColumnValueLocationMaps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.skewedColumnNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.skewedColumnValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.skewedColumnValueLocationMaps());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkewedInfo)) {
            return false;
        }
        SkewedInfo other = (SkewedInfo)obj;
        return Objects.equals(this.skewedColumnNames(), other.skewedColumnNames()) && Objects.equals(this.skewedColumnValues(), other.skewedColumnValues()) && Objects.equals(this.skewedColumnValueLocationMaps(), other.skewedColumnValueLocationMaps());
    }

    public String toString() {
        return ToString.builder((String)"SkewedInfo").add("SkewedColumnNames", this.skewedColumnNames()).add("SkewedColumnValues", this.skewedColumnValues()).add("SkewedColumnValueLocationMaps", this.skewedColumnValueLocationMaps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkewedColumnNames": {
                return Optional.ofNullable(clazz.cast(this.skewedColumnNames()));
            }
            case "SkewedColumnValues": {
                return Optional.ofNullable(clazz.cast(this.skewedColumnValues()));
            }
            case "SkewedColumnValueLocationMaps": {
                return Optional.ofNullable(clazz.cast(this.skewedColumnValueLocationMaps()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SkewedInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> skewedColumnNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> skewedColumnValues = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> skewedColumnValueLocationMaps = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SkewedInfo model) {
            this.skewedColumnNames(model.skewedColumnNames);
            this.skewedColumnValues(model.skewedColumnValues);
            this.skewedColumnValueLocationMaps(model.skewedColumnValueLocationMaps);
        }

        public final Collection<String> getSkewedColumnNames() {
            return this.skewedColumnNames;
        }

        @Override
        public final Builder skewedColumnNames(Collection<String> skewedColumnNames) {
            this.skewedColumnNames = NameStringListCopier.copy(skewedColumnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skewedColumnNames(String ... skewedColumnNames) {
            this.skewedColumnNames(Arrays.asList(skewedColumnNames));
            return this;
        }

        public final void setSkewedColumnNames(Collection<String> skewedColumnNames) {
            this.skewedColumnNames = NameStringListCopier.copy(skewedColumnNames);
        }

        public final Collection<String> getSkewedColumnValues() {
            return this.skewedColumnValues;
        }

        @Override
        public final Builder skewedColumnValues(Collection<String> skewedColumnValues) {
            this.skewedColumnValues = ColumnValueStringListCopier.copy(skewedColumnValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skewedColumnValues(String ... skewedColumnValues) {
            this.skewedColumnValues(Arrays.asList(skewedColumnValues));
            return this;
        }

        public final void setSkewedColumnValues(Collection<String> skewedColumnValues) {
            this.skewedColumnValues = ColumnValueStringListCopier.copy(skewedColumnValues);
        }

        public final Map<String, String> getSkewedColumnValueLocationMaps() {
            return this.skewedColumnValueLocationMaps;
        }

        @Override
        public final Builder skewedColumnValueLocationMaps(Map<String, String> skewedColumnValueLocationMaps) {
            this.skewedColumnValueLocationMaps = LocationMapCopier.copy(skewedColumnValueLocationMaps);
            return this;
        }

        public final void setSkewedColumnValueLocationMaps(Map<String, String> skewedColumnValueLocationMaps) {
            this.skewedColumnValueLocationMaps = LocationMapCopier.copy(skewedColumnValueLocationMaps);
        }

        public SkewedInfo build() {
            return new SkewedInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SkewedInfo> {
        public Builder skewedColumnNames(Collection<String> var1);

        public Builder skewedColumnNames(String ... var1);

        public Builder skewedColumnValues(Collection<String> var1);

        public Builder skewedColumnValues(String ... var1);

        public Builder skewedColumnValueLocationMaps(Map<String, String> var1);
    }
}

