/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CodeGenNodeArg;
import software.amazon.awssdk.services.glue.model.CodeGenNodeArgsCopier;
import software.amazon.awssdk.services.glue.transform.LocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Location
implements StructuredPojo,
ToCopyableBuilder<Builder, Location> {
    private final List<CodeGenNodeArg> jdbc;
    private final List<CodeGenNodeArg> s3;
    private final List<CodeGenNodeArg> dynamoDB;

    private Location(BuilderImpl builder) {
        this.jdbc = builder.jdbc;
        this.s3 = builder.s3;
        this.dynamoDB = builder.dynamoDB;
    }

    public List<CodeGenNodeArg> jdbc() {
        return this.jdbc;
    }

    public List<CodeGenNodeArg> s3() {
        return this.s3;
    }

    public List<CodeGenNodeArg> dynamoDB() {
        return this.dynamoDB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jdbc());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDB());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        return Objects.equals(this.jdbc(), other.jdbc()) && Objects.equals(this.s3(), other.s3()) && Objects.equals(this.dynamoDB(), other.dynamoDB());
    }

    public String toString() {
        return ToString.builder((String)"Location").add("Jdbc", this.jdbc()).add("S3", this.s3()).add("DynamoDB", this.dynamoDB()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Jdbc": {
                return Optional.ofNullable(clazz.cast(this.jdbc()));
            }
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "DynamoDB": {
                return Optional.ofNullable(clazz.cast(this.dynamoDB()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CodeGenNodeArg> jdbc = DefaultSdkAutoConstructList.getInstance();
        private List<CodeGenNodeArg> s3 = DefaultSdkAutoConstructList.getInstance();
        private List<CodeGenNodeArg> dynamoDB = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            this.jdbc(model.jdbc);
            this.s3(model.s3);
            this.dynamoDB(model.dynamoDB);
        }

        public final Collection<CodeGenNodeArg.Builder> getJdbc() {
            return this.jdbc != null ? (Collection)this.jdbc.stream().map(CodeGenNodeArg::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jdbc(Collection<CodeGenNodeArg> jdbc) {
            this.jdbc = CodeGenNodeArgsCopier.copy(jdbc);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jdbc(CodeGenNodeArg ... jdbc) {
            this.jdbc(Arrays.asList(jdbc));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jdbc(Consumer<CodeGenNodeArg.Builder> ... jdbc) {
            this.jdbc(Stream.of(jdbc).map(c -> (CodeGenNodeArg)((CodeGenNodeArg.Builder)CodeGenNodeArg.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJdbc(Collection<CodeGenNodeArg.BuilderImpl> jdbc) {
            this.jdbc = CodeGenNodeArgsCopier.copyFromBuilder(jdbc);
        }

        public final Collection<CodeGenNodeArg.Builder> getS3() {
            return this.s3 != null ? (Collection)this.s3.stream().map(CodeGenNodeArg::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3(Collection<CodeGenNodeArg> s3) {
            this.s3 = CodeGenNodeArgsCopier.copy(s3);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3(CodeGenNodeArg ... s3) {
            this.s3(Arrays.asList(s3));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3(Consumer<CodeGenNodeArg.Builder> ... s3) {
            this.s3(Stream.of(s3).map(c -> (CodeGenNodeArg)((CodeGenNodeArg.Builder)CodeGenNodeArg.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setS3(Collection<CodeGenNodeArg.BuilderImpl> s3) {
            this.s3 = CodeGenNodeArgsCopier.copyFromBuilder(s3);
        }

        public final Collection<CodeGenNodeArg.Builder> getDynamoDB() {
            return this.dynamoDB != null ? (Collection)this.dynamoDB.stream().map(CodeGenNodeArg::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dynamoDB(Collection<CodeGenNodeArg> dynamoDB) {
            this.dynamoDB = CodeGenNodeArgsCopier.copy(dynamoDB);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dynamoDB(CodeGenNodeArg ... dynamoDB) {
            this.dynamoDB(Arrays.asList(dynamoDB));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dynamoDB(Consumer<CodeGenNodeArg.Builder> ... dynamoDB) {
            this.dynamoDB(Stream.of(dynamoDB).map(c -> (CodeGenNodeArg)((CodeGenNodeArg.Builder)CodeGenNodeArg.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDynamoDB(Collection<CodeGenNodeArg.BuilderImpl> dynamoDB) {
            this.dynamoDB = CodeGenNodeArgsCopier.copyFromBuilder(dynamoDB);
        }

        public Location build() {
            return new Location(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Location> {
        public Builder jdbc(Collection<CodeGenNodeArg> var1);

        public Builder jdbc(CodeGenNodeArg ... var1);

        public Builder jdbc(Consumer<CodeGenNodeArg.Builder> ... var1);

        public Builder s3(Collection<CodeGenNodeArg> var1);

        public Builder s3(CodeGenNodeArg ... var1);

        public Builder s3(Consumer<CodeGenNodeArg.Builder> ... var1);

        public Builder dynamoDB(Collection<CodeGenNodeArg> var1);

        public Builder dynamoDB(CodeGenNodeArg ... var1);

        public Builder dynamoDB(Consumer<CodeGenNodeArg.Builder> ... var1);
    }
}

