/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.Partition;
import software.amazon.awssdk.services.glue.model.PartitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPartitionsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetPartitionsResponse> {
    private final List<Partition> partitions;
    private final String nextToken;

    private GetPartitionsResponse(BuilderImpl builder) {
        super(builder);
        this.partitions = builder.partitions;
        this.nextToken = builder.nextToken;
    }

    public List<Partition> partitions() {
        return this.partitions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.partitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPartitionsResponse)) {
            return false;
        }
        GetPartitionsResponse other = (GetPartitionsResponse)((Object)obj);
        return Objects.equals(this.partitions(), other.partitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetPartitionsResponse").add("Partitions", this.partitions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Partitions": {
                return Optional.ofNullable(clazz.cast(this.partitions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<Partition> partitions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPartitionsResponse model) {
            super(model);
            this.partitions(model.partitions);
            this.nextToken(model.nextToken);
        }

        public final Collection<Partition.Builder> getPartitions() {
            return this.partitions != null ? (Collection)this.partitions.stream().map(Partition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partitions(Collection<Partition> partitions) {
            this.partitions = PartitionListCopier.copy(partitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Partition ... partitions) {
            this.partitions(Arrays.asList(partitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitions(Consumer<Partition.Builder> ... partitions) {
            this.partitions(Stream.of(partitions).map(c -> (Partition)((Partition.Builder)Partition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPartitions(Collection<Partition.BuilderImpl> partitions) {
            this.partitions = PartitionListCopier.copyFromBuilder(partitions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetPartitionsResponse build() {
            return new GetPartitionsResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, GetPartitionsResponse> {
        public Builder partitions(Collection<Partition> var1);

        public Builder partitions(Partition ... var1);

        public Builder partitions(Consumer<Partition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

