/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DevEndpoint;
import software.amazon.awssdk.services.glue.model.DevEndpointListCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDevEndpointsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetDevEndpointsResponse> {
    private final List<DevEndpoint> devEndpoints;
    private final String nextToken;

    private GetDevEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.devEndpoints = builder.devEndpoints;
        this.nextToken = builder.nextToken;
    }

    public List<DevEndpoint> devEndpoints() {
        return this.devEndpoints;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.devEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevEndpointsResponse)) {
            return false;
        }
        GetDevEndpointsResponse other = (GetDevEndpointsResponse)((Object)obj);
        return Objects.equals(this.devEndpoints(), other.devEndpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetDevEndpointsResponse").add("DevEndpoints", this.devEndpoints()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DevEndpoints": {
                return Optional.ofNullable(clazz.cast(this.devEndpoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<DevEndpoint> devEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevEndpointsResponse model) {
            super(model);
            this.devEndpoints(model.devEndpoints);
            this.nextToken(model.nextToken);
        }

        public final Collection<DevEndpoint.Builder> getDevEndpoints() {
            return this.devEndpoints != null ? (Collection)this.devEndpoints.stream().map(DevEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devEndpoints(Collection<DevEndpoint> devEndpoints) {
            this.devEndpoints = DevEndpointListCopier.copy(devEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpoints(DevEndpoint ... devEndpoints) {
            this.devEndpoints(Arrays.asList(devEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpoints(Consumer<DevEndpoint.Builder> ... devEndpoints) {
            this.devEndpoints(Stream.of(devEndpoints).map(c -> (DevEndpoint)((DevEndpoint.Builder)DevEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevEndpoints(Collection<DevEndpoint.BuilderImpl> devEndpoints) {
            this.devEndpoints = DevEndpointListCopier.copyFromBuilder(devEndpoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetDevEndpointsResponse build() {
            return new GetDevEndpointsResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, GetDevEndpointsResponse> {
        public Builder devEndpoints(Collection<DevEndpoint> var1);

        public Builder devEndpoints(DevEndpoint ... var1);

        public Builder devEndpoints(Consumer<DevEndpoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

