/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.transform.CreateJsonClassifierRequestMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJsonClassifierRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, CreateJsonClassifierRequest> {
    private final String name;
    private final String jsonPath;

    private CreateJsonClassifierRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.jsonPath = builder.jsonPath;
    }

    public String name() {
        return this.name;
    }

    public String jsonPath() {
        return this.jsonPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonPath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJsonClassifierRequest)) {
            return false;
        }
        CreateJsonClassifierRequest other = (CreateJsonClassifierRequest)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.jsonPath(), other.jsonPath());
    }

    public String toString() {
        return ToString.builder((String)"CreateJsonClassifierRequest").add("Name", (Object)this.name()).add("JsonPath", (Object)this.jsonPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "JsonPath": {
                return Optional.ofNullable(clazz.cast(this.jsonPath()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateJsonClassifierRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String jsonPath;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJsonClassifierRequest model) {
            this.name(model.name);
            this.jsonPath(model.jsonPath);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getJsonPath() {
            return this.jsonPath;
        }

        @Override
        public final Builder jsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        public final void setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
        }

        public CreateJsonClassifierRequest build() {
            return new CreateJsonClassifierRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateJsonClassifierRequest> {
        public Builder name(String var1);

        public Builder jsonPath(String var1);
    }
}

