/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.PublicKeysListCopier;
import software.amazon.awssdk.services.glue.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDevEndpointRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateDevEndpointRequest> {
    private final String endpointName;
    private final String roleArn;
    private final List<String> securityGroupIds;
    private final String subnetId;
    private final String publicKey;
    private final List<String> publicKeys;
    private final Integer numberOfNodes;
    private final String extraPythonLibsS3Path;
    private final String extraJarsS3Path;
    private final String securityConfiguration;

    private CreateDevEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.roleArn = builder.roleArn;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetId = builder.subnetId;
        this.publicKey = builder.publicKey;
        this.publicKeys = builder.publicKeys;
        this.numberOfNodes = builder.numberOfNodes;
        this.extraPythonLibsS3Path = builder.extraPythonLibsS3Path;
        this.extraJarsS3Path = builder.extraJarsS3Path;
        this.securityConfiguration = builder.securityConfiguration;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String publicKey() {
        return this.publicKey;
    }

    public List<String> publicKeys() {
        return this.publicKeys;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public String extraPythonLibsS3Path() {
        return this.extraPythonLibsS3Path;
    }

    public String extraJarsS3Path() {
        return this.extraJarsS3Path;
    }

    public String securityConfiguration() {
        return this.securityConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraPythonLibsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraJarsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDevEndpointRequest)) {
            return false;
        }
        CreateDevEndpointRequest other = (CreateDevEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.publicKey(), other.publicKey()) && Objects.equals(this.publicKeys(), other.publicKeys()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.extraPythonLibsS3Path(), other.extraPythonLibsS3Path()) && Objects.equals(this.extraJarsS3Path(), other.extraJarsS3Path()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"CreateDevEndpointRequest").add("EndpointName", (Object)this.endpointName()).add("RoleArn", (Object)this.roleArn()).add("SecurityGroupIds", this.securityGroupIds()).add("SubnetId", (Object)this.subnetId()).add("PublicKey", (Object)this.publicKey()).add("PublicKeys", this.publicKeys()).add("NumberOfNodes", (Object)this.numberOfNodes()).add("ExtraPythonLibsS3Path", (Object)this.extraPythonLibsS3Path()).add("ExtraJarsS3Path", (Object)this.extraJarsS3Path()).add("SecurityConfiguration", (Object)this.securityConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "PublicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
            case "PublicKeys": {
                return Optional.ofNullable(clazz.cast(this.publicKeys()));
            }
            case "NumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfNodes()));
            }
            case "ExtraPythonLibsS3Path": {
                return Optional.ofNullable(clazz.cast(this.extraPythonLibsS3Path()));
            }
            case "ExtraJarsS3Path": {
                return Optional.ofNullable(clazz.cast(this.extraJarsS3Path()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String endpointName;
        private String roleArn;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String subnetId;
        private String publicKey;
        private List<String> publicKeys = DefaultSdkAutoConstructList.getInstance();
        private Integer numberOfNodes;
        private String extraPythonLibsS3Path;
        private String extraJarsS3Path;
        private String securityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDevEndpointRequest model) {
            super(model);
            this.endpointName(model.endpointName);
            this.roleArn(model.roleArn);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetId(model.subnetId);
            this.publicKey(model.publicKey);
            this.publicKeys(model.publicKeys);
            this.numberOfNodes(model.numberOfNodes);
            this.extraPythonLibsS3Path(model.extraPythonLibsS3Path);
            this.extraJarsS3Path(model.extraJarsS3Path);
            this.securityConfiguration(model.securityConfiguration);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getPublicKey() {
            return this.publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public final Collection<String> getPublicKeys() {
            return this.publicKeys;
        }

        @Override
        public final Builder publicKeys(Collection<String> publicKeys) {
            this.publicKeys = PublicKeysListCopier.copy(publicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicKeys(String ... publicKeys) {
            this.publicKeys(Arrays.asList(publicKeys));
            return this;
        }

        public final void setPublicKeys(Collection<String> publicKeys) {
            this.publicKeys = PublicKeysListCopier.copy(publicKeys);
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final String getExtraPythonLibsS3Path() {
            return this.extraPythonLibsS3Path;
        }

        @Override
        public final Builder extraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
            return this;
        }

        public final void setExtraPythonLibsS3Path(String extraPythonLibsS3Path) {
            this.extraPythonLibsS3Path = extraPythonLibsS3Path;
        }

        public final String getExtraJarsS3Path() {
            return this.extraJarsS3Path;
        }

        @Override
        public final Builder extraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
            return this;
        }

        public final void setExtraJarsS3Path(String extraJarsS3Path) {
            this.extraJarsS3Path = extraJarsS3Path;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDevEndpointRequest build() {
            return new CreateDevEndpointRequest(this);
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    CopyableBuilder<Builder, CreateDevEndpointRequest> {
        public Builder endpointName(String var1);

        public Builder roleArn(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetId(String var1);

        public Builder publicKey(String var1);

        public Builder publicKeys(Collection<String> var1);

        public Builder publicKeys(String ... var1);

        public Builder numberOfNodes(Integer var1);

        public Builder extraPythonLibsS3Path(String var1);

        public Builder extraJarsS3Path(String var1);

        public Builder securityConfiguration(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

