/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.TableVersionError;
import software.amazon.awssdk.services.glue.model.TableVersionErrorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteTableVersionResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchDeleteTableVersionResponse> {
    private final List<TableVersionError> errors;

    private BatchDeleteTableVersionResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    public List<TableVersionError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteTableVersionResponse)) {
            return false;
        }
        BatchDeleteTableVersionResponse other = (BatchDeleteTableVersionResponse)((Object)obj);
        return Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteTableVersionResponse").add("Errors", this.errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<TableVersionError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteTableVersionResponse model) {
            super(model);
            this.errors(model.errors);
        }

        public final Collection<TableVersionError.Builder> getErrors() {
            return this.errors != null ? (Collection)this.errors.stream().map(TableVersionError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<TableVersionError> errors) {
            this.errors = TableVersionErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(TableVersionError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<TableVersionError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (TableVersionError)((TableVersionError.Builder)TableVersionError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<TableVersionError.BuilderImpl> errors) {
            this.errors = TableVersionErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchDeleteTableVersionResponse build() {
            return new BatchDeleteTableVersionResponse(this);
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    CopyableBuilder<Builder, BatchDeleteTableVersionResponse> {
        public Builder errors(Collection<TableVersionError> var1);

        public Builder errors(TableVersionError ... var1);

        public Builder errors(Consumer<TableVersionError.Builder> ... var1);
    }
}

