/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.StartJobRunRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartJobRunRequestModelMarshaller {
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<String> JOBRUNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobRunId").isBinary(false).build();
    private static final MarshallingInfo<Map> ARGUMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arguments").isBinary(false).build();
    private static final MarshallingInfo<Integer> ALLOCATEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllocatedCapacity").isBinary(false).build();
    private static final StartJobRunRequestModelMarshaller INSTANCE = new StartJobRunRequestModelMarshaller();

    private StartJobRunRequestModelMarshaller() {
    }

    public static StartJobRunRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartJobRunRequest startJobRunRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)startJobRunRequest), (String)"startJobRunRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)startJobRunRequest.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)startJobRunRequest.jobRunId(), JOBRUNID_BINDING);
            protocolMarshaller.marshall(startJobRunRequest.arguments(), ARGUMENTS_BINDING);
            protocolMarshaller.marshall((Object)startJobRunRequest.allocatedCapacity(), ALLOCATEDCAPACITY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

