/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.SerDeInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SerDeInfoMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> SERIALIZATIONLIBRARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SerializationLibrary").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final SerDeInfoMarshaller INSTANCE = new SerDeInfoMarshaller();

    private SerDeInfoMarshaller() {
    }

    public static SerDeInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SerDeInfo serDeInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)serDeInfo, (String)"serDeInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)serDeInfo.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)serDeInfo.serializationLibrary(), SERIALIZATIONLIBRARY_BINDING);
            protocolMarshaller.marshall(serDeInfo.parameters(), PARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

