/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.Job;
import software.amazon.awssdk.services.glue.transform.ConnectionsListUnmarshaller;
import software.amazon.awssdk.services.glue.transform.ExecutionPropertyUnmarshaller;
import software.amazon.awssdk.services.glue.transform.JobCommandUnmarshaller;

public class JobUnmarshaller
implements Unmarshaller<Job, JsonUnmarshallerContext> {
    private static final JobUnmarshaller INSTANCE = new JobUnmarshaller();

    public Job unmarshall(JsonUnmarshallerContext context) throws Exception {
        Job.Builder jobBuilder = Job.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    jobBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    jobBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LogUri", targetDepth)) {
                    context.nextToken();
                    jobBuilder.logUri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Role", targetDepth)) {
                    context.nextToken();
                    jobBuilder.role((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreatedOn", targetDepth)) {
                    context.nextToken();
                    jobBuilder.createdOn((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastModifiedOn", targetDepth)) {
                    context.nextToken();
                    jobBuilder.lastModifiedOn((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExecutionProperty", targetDepth)) {
                    context.nextToken();
                    jobBuilder.executionProperty(ExecutionPropertyUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Command", targetDepth)) {
                    context.nextToken();
                    jobBuilder.command(JobCommandUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DefaultArguments", targetDepth)) {
                    context.nextToken();
                    jobBuilder.defaultArguments(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Connections", targetDepth)) {
                    context.nextToken();
                    jobBuilder.connections(ConnectionsListUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("MaxRetries", targetDepth)) {
                    context.nextToken();
                    jobBuilder.maxRetries((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("AllocatedCapacity", targetDepth)) {
                    context.nextToken();
                    jobBuilder.allocatedCapacity((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Job)jobBuilder.build();
    }

    public static JobUnmarshaller getInstance() {
        return INSTANCE;
    }
}

