/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.CodeGenNodeArg;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CodeGenNodeArgMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final MarshallingInfo<Boolean> PARAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Param").isBinary(false).build();
    private static final CodeGenNodeArgMarshaller INSTANCE = new CodeGenNodeArgMarshaller();

    private CodeGenNodeArgMarshaller() {
    }

    public static CodeGenNodeArgMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CodeGenNodeArg codeGenNodeArg, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)codeGenNodeArg, (String)"codeGenNodeArg");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)codeGenNodeArg.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)codeGenNodeArg.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)codeGenNodeArg.param(), PARAM_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

