/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.Classifier;
import software.amazon.awssdk.services.glue.transform.GrokClassifierUnmarshaller;
import software.amazon.awssdk.services.glue.transform.XMLClassifierUnmarshaller;

public class ClassifierUnmarshaller
implements Unmarshaller<Classifier, JsonUnmarshallerContext> {
    private static final ClassifierUnmarshaller INSTANCE = new ClassifierUnmarshaller();

    public Classifier unmarshall(JsonUnmarshallerContext context) throws Exception {
        Classifier.Builder classifierBuilder = Classifier.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("GrokClassifier", targetDepth)) {
                    context.nextToken();
                    classifierBuilder.grokClassifier(GrokClassifierUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("XMLClassifier", targetDepth)) {
                    context.nextToken();
                    classifierBuilder.xmlClassifier(XMLClassifierUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Classifier)classifierBuilder.build();
    }

    public static ClassifierUnmarshaller getInstance() {
        return INSTANCE;
    }
}

