/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.CatalogEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CatalogEntryMarshaller {
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final CatalogEntryMarshaller INSTANCE = new CatalogEntryMarshaller();

    private CatalogEntryMarshaller() {
    }

    public static CatalogEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CatalogEntry catalogEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)catalogEntry, (String)"catalogEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)catalogEntry.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)catalogEntry.tableName(), TABLENAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

