/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsRequest;
import software.amazon.awssdk.services.glue.model.GetDevEndpointsResponse;

public class GetDevEndpointsPublisher
implements SdkPublisher<GetDevEndpointsResponse> {
    private final GlueAsyncClient client;
    private final GetDevEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDevEndpointsPublisher(GlueAsyncClient client, GetDevEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDevEndpointsPublisher(GlueAsyncClient client, GetDevEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDevEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDevEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetDevEndpointsPublisher resume(GetDevEndpointsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetDevEndpointsPublisher(this.client, (GetDevEndpointsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetDevEndpointsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetDevEndpointsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetDevEndpointsResponseFetcher
    implements AsyncPageFetcher<GetDevEndpointsResponse> {
        private GetDevEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(GetDevEndpointsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<GetDevEndpointsResponse> nextPage(GetDevEndpointsResponse previousPage) {
            if (previousPage == null) {
                return GetDevEndpointsPublisher.this.client.getDevEndpoints(GetDevEndpointsPublisher.this.firstRequest);
            }
            return GetDevEndpointsPublisher.this.client.getDevEndpoints((GetDevEndpointsRequest)((Object)GetDevEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

