/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.PrincipalType;
import software.amazon.awssdk.services.glue.model.ResourceUri;
import software.amazon.awssdk.services.glue.model.ResourceUriListCopier;
import software.amazon.awssdk.services.glue.transform.UserDefinedFunctionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserDefinedFunction
implements StructuredPojo,
ToCopyableBuilder<Builder, UserDefinedFunction> {
    private final String functionName;
    private final String className;
    private final String ownerName;
    private final String ownerType;
    private final Instant createTime;
    private final List<ResourceUri> resourceUris;

    private UserDefinedFunction(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.className = builder.className;
        this.ownerName = builder.ownerName;
        this.ownerType = builder.ownerType;
        this.createTime = builder.createTime;
        this.resourceUris = builder.resourceUris;
    }

    public String functionName() {
        return this.functionName;
    }

    public String className() {
        return this.className;
    }

    public String ownerName() {
        return this.ownerName;
    }

    public PrincipalType ownerType() {
        return PrincipalType.fromValue(this.ownerType);
    }

    public String ownerTypeAsString() {
        return this.ownerType;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public List<ResourceUri> resourceUris() {
        return this.resourceUris;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.className());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceUris());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserDefinedFunction)) {
            return false;
        }
        UserDefinedFunction other = (UserDefinedFunction)obj;
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.className(), other.className()) && Objects.equals(this.ownerName(), other.ownerName()) && Objects.equals(this.ownerTypeAsString(), other.ownerTypeAsString()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.resourceUris(), other.resourceUris());
    }

    public String toString() {
        return ToString.builder((String)"UserDefinedFunction").add("FunctionName", (Object)this.functionName()).add("ClassName", (Object)this.className()).add("OwnerName", (Object)this.ownerName()).add("OwnerType", (Object)this.ownerTypeAsString()).add("CreateTime", (Object)this.createTime()).add("ResourceUris", this.resourceUris()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "ClassName": {
                return Optional.ofNullable(clazz.cast(this.className()));
            }
            case "OwnerName": {
                return Optional.ofNullable(clazz.cast(this.ownerName()));
            }
            case "OwnerType": {
                return Optional.ofNullable(clazz.cast(this.ownerTypeAsString()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "ResourceUris": {
                return Optional.ofNullable(clazz.cast(this.resourceUris()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserDefinedFunctionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionName;
        private String className;
        private String ownerName;
        private String ownerType;
        private Instant createTime;
        private List<ResourceUri> resourceUris = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserDefinedFunction model) {
            this.functionName(model.functionName);
            this.className(model.className);
            this.ownerName(model.ownerName);
            this.ownerType(model.ownerType);
            this.createTime(model.createTime);
            this.resourceUris(model.resourceUris);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getClassName() {
            return this.className;
        }

        @Override
        public final Builder className(String className) {
            this.className = className;
            return this;
        }

        public final void setClassName(String className) {
            this.className = className;
        }

        public final String getOwnerName() {
            return this.ownerName;
        }

        @Override
        public final Builder ownerName(String ownerName) {
            this.ownerName = ownerName;
            return this;
        }

        public final void setOwnerName(String ownerName) {
            this.ownerName = ownerName;
        }

        public final String getOwnerType() {
            return this.ownerType;
        }

        @Override
        public final Builder ownerType(String ownerType) {
            this.ownerType = ownerType;
            return this;
        }

        @Override
        public final Builder ownerType(PrincipalType ownerType) {
            this.ownerType(ownerType.toString());
            return this;
        }

        public final void setOwnerType(String ownerType) {
            this.ownerType = ownerType;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Collection<ResourceUri.Builder> getResourceUris() {
            return this.resourceUris != null ? (Collection)this.resourceUris.stream().map(ResourceUri::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceUris(Collection<ResourceUri> resourceUris) {
            this.resourceUris = ResourceUriListCopier.copy(resourceUris);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceUris(ResourceUri ... resourceUris) {
            this.resourceUris(Arrays.asList(resourceUris));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceUris(Consumer<ResourceUri.Builder> ... resourceUris) {
            this.resourceUris(Stream.of(resourceUris).map(c -> (ResourceUri)((ResourceUri.Builder)ResourceUri.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceUris(Collection<ResourceUri.BuilderImpl> resourceUris) {
            this.resourceUris = ResourceUriListCopier.copyFromBuilder(resourceUris);
        }

        public UserDefinedFunction build() {
            return new UserDefinedFunction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UserDefinedFunction> {
        public Builder functionName(String var1);

        public Builder className(String var1);

        public Builder ownerName(String var1);

        public Builder ownerType(String var1);

        public Builder ownerType(PrincipalType var1);

        public Builder createTime(Instant var1);

        public Builder resourceUris(Collection<ResourceUri> var1);

        public Builder resourceUris(ResourceUri ... var1);

        public Builder resourceUris(Consumer<ResourceUri.Builder> ... var1);
    }
}

