/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ConnectionsList;
import software.amazon.awssdk.services.glue.model.ExecutionProperty;
import software.amazon.awssdk.services.glue.model.GenericMapCopier;
import software.amazon.awssdk.services.glue.model.JobCommand;
import software.amazon.awssdk.services.glue.transform.JobUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, JobUpdate> {
    private final String description;
    private final String logUri;
    private final String role;
    private final ExecutionProperty executionProperty;
    private final JobCommand command;
    private final Map<String, String> defaultArguments;
    private final ConnectionsList connections;
    private final Integer maxRetries;
    private final Integer allocatedCapacity;

    private JobUpdate(BuilderImpl builder) {
        this.description = builder.description;
        this.logUri = builder.logUri;
        this.role = builder.role;
        this.executionProperty = builder.executionProperty;
        this.command = builder.command;
        this.defaultArguments = builder.defaultArguments;
        this.connections = builder.connections;
        this.maxRetries = builder.maxRetries;
        this.allocatedCapacity = builder.allocatedCapacity;
    }

    public String description() {
        return this.description;
    }

    public String logUri() {
        return this.logUri;
    }

    public String role() {
        return this.role;
    }

    public ExecutionProperty executionProperty() {
        return this.executionProperty;
    }

    public JobCommand command() {
        return this.command;
    }

    public Map<String, String> defaultArguments() {
        return this.defaultArguments;
    }

    public ConnectionsList connections() {
        return this.connections;
    }

    public Integer maxRetries() {
        return this.maxRetries;
    }

    public Integer allocatedCapacity() {
        return this.allocatedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionProperty());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultArguments());
        hashCode = 31 * hashCode + Objects.hashCode(this.connections());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobUpdate)) {
            return false;
        }
        JobUpdate other = (JobUpdate)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.executionProperty(), other.executionProperty()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.defaultArguments(), other.defaultArguments()) && Objects.equals(this.connections(), other.connections()) && Objects.equals(this.maxRetries(), other.maxRetries()) && Objects.equals(this.allocatedCapacity(), other.allocatedCapacity());
    }

    public String toString() {
        return ToString.builder((String)"JobUpdate").add("Description", (Object)this.description()).add("LogUri", (Object)this.logUri()).add("Role", (Object)this.role()).add("ExecutionProperty", (Object)this.executionProperty()).add("Command", (Object)this.command()).add("DefaultArguments", this.defaultArguments()).add("Connections", (Object)this.connections()).add("MaxRetries", (Object)this.maxRetries()).add("AllocatedCapacity", (Object)this.allocatedCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LogUri": {
                return Optional.ofNullable(clazz.cast(this.logUri()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "ExecutionProperty": {
                return Optional.ofNullable(clazz.cast(this.executionProperty()));
            }
            case "Command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "DefaultArguments": {
                return Optional.ofNullable(clazz.cast(this.defaultArguments()));
            }
            case "Connections": {
                return Optional.ofNullable(clazz.cast(this.connections()));
            }
            case "MaxRetries": {
                return Optional.ofNullable(clazz.cast(this.maxRetries()));
            }
            case "AllocatedCapacity": {
                return Optional.ofNullable(clazz.cast(this.allocatedCapacity()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String logUri;
        private String role;
        private ExecutionProperty executionProperty;
        private JobCommand command;
        private Map<String, String> defaultArguments = DefaultSdkAutoConstructMap.getInstance();
        private ConnectionsList connections;
        private Integer maxRetries;
        private Integer allocatedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(JobUpdate model) {
            this.description(model.description);
            this.logUri(model.logUri);
            this.role(model.role);
            this.executionProperty(model.executionProperty);
            this.command(model.command);
            this.defaultArguments(model.defaultArguments);
            this.connections(model.connections);
            this.maxRetries(model.maxRetries);
            this.allocatedCapacity(model.allocatedCapacity);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final ExecutionProperty.Builder getExecutionProperty() {
            return this.executionProperty != null ? this.executionProperty.toBuilder() : null;
        }

        @Override
        public final Builder executionProperty(ExecutionProperty executionProperty) {
            this.executionProperty = executionProperty;
            return this;
        }

        public final void setExecutionProperty(ExecutionProperty.BuilderImpl executionProperty) {
            this.executionProperty = executionProperty != null ? executionProperty.build() : null;
        }

        public final JobCommand.Builder getCommand() {
            return this.command != null ? this.command.toBuilder() : null;
        }

        @Override
        public final Builder command(JobCommand command) {
            this.command = command;
            return this;
        }

        public final void setCommand(JobCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        public final Map<String, String> getDefaultArguments() {
            return this.defaultArguments;
        }

        @Override
        public final Builder defaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = GenericMapCopier.copy(defaultArguments);
            return this;
        }

        public final void setDefaultArguments(Map<String, String> defaultArguments) {
            this.defaultArguments = GenericMapCopier.copy(defaultArguments);
        }

        public final ConnectionsList.Builder getConnections() {
            return this.connections != null ? this.connections.toBuilder() : null;
        }

        @Override
        public final Builder connections(ConnectionsList connections) {
            this.connections = connections;
            return this;
        }

        public final void setConnections(ConnectionsList.BuilderImpl connections) {
            this.connections = connections != null ? connections.build() : null;
        }

        public final Integer getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        public final Integer getAllocatedCapacity() {
            return this.allocatedCapacity;
        }

        @Override
        public final Builder allocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
            return this;
        }

        public final void setAllocatedCapacity(Integer allocatedCapacity) {
            this.allocatedCapacity = allocatedCapacity;
        }

        public JobUpdate build() {
            return new JobUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobUpdate> {
        public Builder description(String var1);

        public Builder logUri(String var1);

        public Builder role(String var1);

        public Builder executionProperty(ExecutionProperty var1);

        default public Builder executionProperty(Consumer<ExecutionProperty.Builder> executionProperty) {
            return this.executionProperty((ExecutionProperty)((ExecutionProperty.Builder)ExecutionProperty.builder().applyMutation(executionProperty)).build());
        }

        public Builder command(JobCommand var1);

        default public Builder command(Consumer<JobCommand.Builder> command) {
            return this.command((JobCommand)((JobCommand.Builder)JobCommand.builder().applyMutation(command)).build());
        }

        public Builder defaultArguments(Map<String, String> var1);

        public Builder connections(ConnectionsList var1);

        default public Builder connections(Consumer<ConnectionsList.Builder> connections) {
            return this.connections((ConnectionsList)((ConnectionsList.Builder)ConnectionsList.builder().applyMutation(connections)).build());
        }

        public Builder maxRetries(Integer var1);

        public Builder allocatedCapacity(Integer var1);
    }
}

