/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.JdbcTarget;
import software.amazon.awssdk.services.glue.model.JdbcTargetListCopier;
import software.amazon.awssdk.services.glue.model.S3Target;
import software.amazon.awssdk.services.glue.model.S3TargetListCopier;
import software.amazon.awssdk.services.glue.transform.CrawlerTargetsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CrawlerTargets
implements StructuredPojo,
ToCopyableBuilder<Builder, CrawlerTargets> {
    private final List<S3Target> s3Targets;
    private final List<JdbcTarget> jdbcTargets;

    private CrawlerTargets(BuilderImpl builder) {
        this.s3Targets = builder.s3Targets;
        this.jdbcTargets = builder.jdbcTargets;
    }

    public List<S3Target> s3Targets() {
        return this.s3Targets;
    }

    public List<JdbcTarget> jdbcTargets() {
        return this.jdbcTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.jdbcTargets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrawlerTargets)) {
            return false;
        }
        CrawlerTargets other = (CrawlerTargets)obj;
        return Objects.equals(this.s3Targets(), other.s3Targets()) && Objects.equals(this.jdbcTargets(), other.jdbcTargets());
    }

    public String toString() {
        return ToString.builder((String)"CrawlerTargets").add("S3Targets", this.s3Targets()).add("JdbcTargets", this.jdbcTargets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Targets": {
                return Optional.ofNullable(clazz.cast(this.s3Targets()));
            }
            case "JdbcTargets": {
                return Optional.ofNullable(clazz.cast(this.jdbcTargets()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CrawlerTargetsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<S3Target> s3Targets = DefaultSdkAutoConstructList.getInstance();
        private List<JdbcTarget> jdbcTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CrawlerTargets model) {
            this.s3Targets(model.s3Targets);
            this.jdbcTargets(model.jdbcTargets);
        }

        public final Collection<S3Target.Builder> getS3Targets() {
            return this.s3Targets != null ? (Collection)this.s3Targets.stream().map(S3Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3Targets(Collection<S3Target> s3Targets) {
            this.s3Targets = S3TargetListCopier.copy(s3Targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Targets(S3Target ... s3Targets) {
            this.s3Targets(Arrays.asList(s3Targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Targets(Consumer<S3Target.Builder> ... s3Targets) {
            this.s3Targets(Stream.of(s3Targets).map(c -> (S3Target)((S3Target.Builder)S3Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setS3Targets(Collection<S3Target.BuilderImpl> s3Targets) {
            this.s3Targets = S3TargetListCopier.copyFromBuilder(s3Targets);
        }

        public final Collection<JdbcTarget.Builder> getJdbcTargets() {
            return this.jdbcTargets != null ? (Collection)this.jdbcTargets.stream().map(JdbcTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jdbcTargets(Collection<JdbcTarget> jdbcTargets) {
            this.jdbcTargets = JdbcTargetListCopier.copy(jdbcTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jdbcTargets(JdbcTarget ... jdbcTargets) {
            this.jdbcTargets(Arrays.asList(jdbcTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jdbcTargets(Consumer<JdbcTarget.Builder> ... jdbcTargets) {
            this.jdbcTargets(Stream.of(jdbcTargets).map(c -> (JdbcTarget)((JdbcTarget.Builder)JdbcTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJdbcTargets(Collection<JdbcTarget.BuilderImpl> jdbcTargets) {
            this.jdbcTargets = JdbcTargetListCopier.copyFromBuilder(jdbcTargets);
        }

        public CrawlerTargets build() {
            return new CrawlerTargets(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CrawlerTargets> {
        public Builder s3Targets(Collection<S3Target> var1);

        public Builder s3Targets(S3Target ... var1);

        public Builder s3Targets(Consumer<S3Target.Builder> ... var1);

        public Builder jdbcTargets(Collection<JdbcTarget> var1);

        public Builder jdbcTargets(JdbcTarget ... var1);

        public Builder jdbcTargets(Consumer<JdbcTarget.Builder> ... var1);
    }
}

