/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.XMLClassifier;

public class XMLClassifierUnmarshaller
implements Unmarshaller<XMLClassifier, JsonUnmarshallerContext> {
    private static final XMLClassifierUnmarshaller INSTANCE = new XMLClassifierUnmarshaller();

    public XMLClassifier unmarshall(JsonUnmarshallerContext context) throws Exception {
        XMLClassifier.Builder xmlClassifierBuilder = XMLClassifier.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    xmlClassifierBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Classification", targetDepth)) {
                    context.nextToken();
                    xmlClassifierBuilder.classification((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    xmlClassifierBuilder.creationTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastUpdated", targetDepth)) {
                    context.nextToken();
                    xmlClassifierBuilder.lastUpdated((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Version", targetDepth)) {
                    context.nextToken();
                    xmlClassifierBuilder.version((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("RowTag", targetDepth)) {
                    context.nextToken();
                    xmlClassifierBuilder.rowTag((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (XMLClassifier)xmlClassifierBuilder.build();
    }

    public static XMLClassifierUnmarshaller getInstance() {
        return INSTANCE;
    }
}

