/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.UserDefinedFunction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserDefinedFunctionMarshaller {
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionName").isBinary(false).build();
    private static final MarshallingInfo<String> CLASSNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClassName").isBinary(false).build();
    private static final MarshallingInfo<String> OWNERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerName").isBinary(false).build();
    private static final MarshallingInfo<String> OWNERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerType").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTime").isBinary(false).build();
    private static final MarshallingInfo<List> RESOURCEURIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceUris").isBinary(false).build();
    private static final UserDefinedFunctionMarshaller INSTANCE = new UserDefinedFunctionMarshaller();

    private UserDefinedFunctionMarshaller() {
    }

    public static UserDefinedFunctionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserDefinedFunction userDefinedFunction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)userDefinedFunction, (String)"userDefinedFunction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)userDefinedFunction.functionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)userDefinedFunction.className(), CLASSNAME_BINDING);
            protocolMarshaller.marshall((Object)userDefinedFunction.ownerName(), OWNERNAME_BINDING);
            protocolMarshaller.marshall((Object)userDefinedFunction.ownerTypeAsString(), OWNERTYPE_BINDING);
            protocolMarshaller.marshall((Object)userDefinedFunction.createTime(), CREATETIME_BINDING);
            protocolMarshaller.marshall(userDefinedFunction.resourceUris(), RESOURCEURIS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

