/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.UpdatePartitionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdatePartitionRequestModelMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<List> PARTITIONVALUELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionValueList").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PARTITIONINPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionInput").isBinary(false).build();
    private static final UpdatePartitionRequestModelMarshaller INSTANCE = new UpdatePartitionRequestModelMarshaller();

    private UpdatePartitionRequestModelMarshaller() {
    }

    public static UpdatePartitionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdatePartitionRequest updatePartitionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updatePartitionRequest), (String)"updatePartitionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updatePartitionRequest.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)updatePartitionRequest.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)updatePartitionRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(updatePartitionRequest.partitionValueList(), PARTITIONVALUELIST_BINDING);
            protocolMarshaller.marshall((Object)updatePartitionRequest.partitionInput(), PARTITIONINPUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

