/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.Trigger;
import software.amazon.awssdk.services.glue.transform.ActionUnmarshaller;
import software.amazon.awssdk.services.glue.transform.PredicateUnmarshaller;

public class TriggerUnmarshaller
implements Unmarshaller<Trigger, JsonUnmarshallerContext> {
    private static final TriggerUnmarshaller INSTANCE = new TriggerUnmarshaller();

    public Trigger unmarshall(JsonUnmarshallerContext context) throws Exception {
        Trigger.Builder triggerBuilder = Trigger.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    triggerBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    triggerBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    triggerBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    triggerBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    triggerBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Schedule", targetDepth)) {
                    context.nextToken();
                    triggerBuilder.schedule((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Actions", targetDepth)) {
                    context.nextToken();
                    triggerBuilder.actions(new ListUnmarshaller((Unmarshaller)ActionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Predicate", targetDepth)) {
                    context.nextToken();
                    triggerBuilder.predicate(PredicateUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Trigger)triggerBuilder.build();
    }

    public static TriggerUnmarshaller getInstance() {
        return INSTANCE;
    }
}

