/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.transform.ColumnUnmarshaller;
import software.amazon.awssdk.services.glue.transform.StorageDescriptorUnmarshaller;

public class TableUnmarshaller
implements Unmarshaller<Table, JsonUnmarshallerContext> {
    private static final TableUnmarshaller INSTANCE = new TableUnmarshaller();

    public Table unmarshall(JsonUnmarshallerContext context) throws Exception {
        Table.Builder tableBuilder = Table.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    tableBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DatabaseName", targetDepth)) {
                    context.nextToken();
                    tableBuilder.databaseName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    tableBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Owner", targetDepth)) {
                    context.nextToken();
                    tableBuilder.owner((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreateTime", targetDepth)) {
                    context.nextToken();
                    tableBuilder.createTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("UpdateTime", targetDepth)) {
                    context.nextToken();
                    tableBuilder.updateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastAccessTime", targetDepth)) {
                    context.nextToken();
                    tableBuilder.lastAccessTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastAnalyzedTime", targetDepth)) {
                    context.nextToken();
                    tableBuilder.lastAnalyzedTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Retention", targetDepth)) {
                    context.nextToken();
                    tableBuilder.retention((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("StorageDescriptor", targetDepth)) {
                    context.nextToken();
                    tableBuilder.storageDescriptor(StorageDescriptorUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("PartitionKeys", targetDepth)) {
                    context.nextToken();
                    tableBuilder.partitionKeys(new ListUnmarshaller((Unmarshaller)ColumnUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ViewOriginalText", targetDepth)) {
                    context.nextToken();
                    tableBuilder.viewOriginalText((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ViewExpandedText", targetDepth)) {
                    context.nextToken();
                    tableBuilder.viewExpandedText((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TableType", targetDepth)) {
                    context.nextToken();
                    tableBuilder.tableType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    tableBuilder.parameters(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("CreatedBy", targetDepth)) {
                    context.nextToken();
                    tableBuilder.createdBy((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Table)tableBuilder.build();
    }

    public static TableUnmarshaller getInstance() {
        return INSTANCE;
    }
}

