/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TableInputMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTACCESSTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAccessTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTANALYZEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAnalyzedTime").isBinary(false).build();
    private static final MarshallingInfo<Integer> RETENTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Retention").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STORAGEDESCRIPTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageDescriptor").isBinary(false).build();
    private static final MarshallingInfo<List> PARTITIONKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionKeys").isBinary(false).build();
    private static final MarshallingInfo<String> VIEWORIGINALTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ViewOriginalText").isBinary(false).build();
    private static final MarshallingInfo<String> VIEWEXPANDEDTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ViewExpandedText").isBinary(false).build();
    private static final MarshallingInfo<String> TABLETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableType").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").isBinary(false).build();
    private static final TableInputMarshaller INSTANCE = new TableInputMarshaller();

    private TableInputMarshaller() {
    }

    public static TableInputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TableInput tableInput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)tableInput, (String)"tableInput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)tableInput.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)tableInput.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)tableInput.owner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)tableInput.lastAccessTime(), LASTACCESSTIME_BINDING);
            protocolMarshaller.marshall((Object)tableInput.lastAnalyzedTime(), LASTANALYZEDTIME_BINDING);
            protocolMarshaller.marshall((Object)tableInput.retention(), RETENTION_BINDING);
            protocolMarshaller.marshall((Object)tableInput.storageDescriptor(), STORAGEDESCRIPTOR_BINDING);
            protocolMarshaller.marshall(tableInput.partitionKeys(), PARTITIONKEYS_BINDING);
            protocolMarshaller.marshall((Object)tableInput.viewOriginalText(), VIEWORIGINALTEXT_BINDING);
            protocolMarshaller.marshall((Object)tableInput.viewExpandedText(), VIEWEXPANDEDTEXT_BINDING);
            protocolMarshaller.marshall((Object)tableInput.tableType(), TABLETYPE_BINDING);
            protocolMarshaller.marshall(tableInput.parameters(), PARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

