/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.glue.model.SkewedInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SkewedInfoMarshaller {
    private static final MarshallingInfo<List> SKEWEDCOLUMNNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkewedColumnNames").isBinary(false).build();
    private static final MarshallingInfo<List> SKEWEDCOLUMNVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkewedColumnValues").isBinary(false).build();
    private static final MarshallingInfo<Map> SKEWEDCOLUMNVALUELOCATIONMAPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkewedColumnValueLocationMaps").isBinary(false).build();
    private static final SkewedInfoMarshaller INSTANCE = new SkewedInfoMarshaller();

    private SkewedInfoMarshaller() {
    }

    public static SkewedInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SkewedInfo skewedInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)skewedInfo, (String)"skewedInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(skewedInfo.skewedColumnNames(), SKEWEDCOLUMNNAMES_BINDING);
            protocolMarshaller.marshall(skewedInfo.skewedColumnValues(), SKEWEDCOLUMNVALUES_BINDING);
            protocolMarshaller.marshall(skewedInfo.skewedColumnValueLocationMaps(), SKEWEDCOLUMNVALUELOCATIONMAPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

