/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.SerDeInfo;

public class SerDeInfoUnmarshaller
implements Unmarshaller<SerDeInfo, JsonUnmarshallerContext> {
    private static final SerDeInfoUnmarshaller INSTANCE = new SerDeInfoUnmarshaller();

    public SerDeInfo unmarshall(JsonUnmarshallerContext context) throws Exception {
        SerDeInfo.Builder serDeInfoBuilder = SerDeInfo.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    serDeInfoBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SerializationLibrary", targetDepth)) {
                    context.nextToken();
                    serDeInfoBuilder.serializationLibrary((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Parameters", targetDepth)) {
                    context.nextToken();
                    serDeInfoBuilder.parameters(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SerDeInfo)serDeInfoBuilder.build();
    }

    public static SerDeInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}

