/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.ResourceUri;

public class ResourceUriUnmarshaller
implements Unmarshaller<ResourceUri, JsonUnmarshallerContext> {
    private static final ResourceUriUnmarshaller INSTANCE = new ResourceUriUnmarshaller();

    public ResourceUri unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourceUri.Builder resourceUriBuilder = ResourceUri.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ResourceType", targetDepth)) {
                    context.nextToken();
                    resourceUriBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Uri", targetDepth)) {
                    context.nextToken();
                    resourceUriBuilder.uri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResourceUri)resourceUriBuilder.build();
    }

    public static ResourceUriUnmarshaller getInstance() {
        return INSTANCE;
    }
}

