/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.glue.model.GetCrawlerMetricsRequest;
import software.amazon.awssdk.services.glue.transform.GetCrawlerMetricsRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetCrawlerMetricsRequestMarshaller
implements Marshaller<Request<GetCrawlerMetricsRequest>, GetCrawlerMetricsRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSGlue.GetCrawlerMetrics").serviceName("AWS Glue").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public GetCrawlerMetricsRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetCrawlerMetricsRequest> marshall(GetCrawlerMetricsRequest getCrawlerMetricsRequest) {
        Validate.paramNotNull((Object)((Object)getCrawlerMetricsRequest), (String)"getCrawlerMetricsRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)getCrawlerMetricsRequest);
            protocolMarshaller.startMarshalling();
            GetCrawlerMetricsRequestModelMarshaller.getInstance().marshall(getCrawlerMetricsRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

