/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateDatabaseRequestModelMarshaller {
    private static final MarshallingInfo<String> CATALOGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DATABASEINPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseInput").isBinary(false).build();
    private static final CreateDatabaseRequestModelMarshaller INSTANCE = new CreateDatabaseRequestModelMarshaller();

    private CreateDatabaseRequestModelMarshaller() {
    }

    public static CreateDatabaseRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDatabaseRequest createDatabaseRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createDatabaseRequest), (String)"createDatabaseRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createDatabaseRequest.catalogId(), CATALOGID_BINDING);
            protocolMarshaller.marshall((Object)createDatabaseRequest.databaseInput(), DATABASEINPUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

