/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.glue.model.Crawler;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CrawlerMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> ROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Role").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<List> CLASSIFIERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Classifiers").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SCHEMACHANGEPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaChangePolicy").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<String> TABLEPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TablePrefix").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SCHEDULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Schedule").isBinary(false).build();
    private static final MarshallingInfo<Long> CRAWLELAPSEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CrawlElapsedTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdated").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LASTCRAWL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastCrawl").isBinary(false).build();
    private static final MarshallingInfo<Long> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final MarshallingInfo<String> CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configuration").isBinary(false).build();
    private static final CrawlerMarshaller INSTANCE = new CrawlerMarshaller();

    private CrawlerMarshaller() {
    }

    public static CrawlerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Crawler crawler, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)crawler, (String)"crawler");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)crawler.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)crawler.role(), ROLE_BINDING);
            protocolMarshaller.marshall((Object)crawler.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)crawler.databaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall((Object)crawler.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(crawler.classifiers(), CLASSIFIERS_BINDING);
            protocolMarshaller.marshall((Object)crawler.schemaChangePolicy(), SCHEMACHANGEPOLICY_BINDING);
            protocolMarshaller.marshall((Object)crawler.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)crawler.tablePrefix(), TABLEPREFIX_BINDING);
            protocolMarshaller.marshall((Object)crawler.schedule(), SCHEDULE_BINDING);
            protocolMarshaller.marshall((Object)crawler.crawlElapsedTime(), CRAWLELAPSEDTIME_BINDING);
            protocolMarshaller.marshall((Object)crawler.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)crawler.lastUpdated(), LASTUPDATED_BINDING);
            protocolMarshaller.marshall((Object)crawler.lastCrawl(), LASTCRAWL_BINDING);
            protocolMarshaller.marshall((Object)crawler.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)crawler.configuration(), CONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

