/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.glue.model.ConnectionsList;

public class ConnectionsListUnmarshaller
implements Unmarshaller<ConnectionsList, JsonUnmarshallerContext> {
    private static final ConnectionsListUnmarshaller INSTANCE = new ConnectionsListUnmarshaller();

    public ConnectionsList unmarshall(JsonUnmarshallerContext context) throws Exception {
        ConnectionsList.Builder connectionsListBuilder = ConnectionsList.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Connections", targetDepth)) {
                    context.nextToken();
                    connectionsListBuilder.connections(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ConnectionsList)connectionsListBuilder.build();
    }

    public static ConnectionsListUnmarshaller getInstance() {
        return INSTANCE;
    }
}

