/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.GetTableVersionsRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionsResponse;

public class GetTableVersionsIterable
implements SdkIterable<GetTableVersionsResponse> {
    private final GlueClient client;
    private final GetTableVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTableVersionsIterable(GlueClient client, GetTableVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetTableVersionsResponseFetcher();
    }

    public Iterator<GetTableVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetTableVersionsIterable resume(GetTableVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetTableVersionsIterable(this.client, (GetTableVersionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetTableVersionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetTableVersionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetTableVersionsResponseFetcher
    implements SyncPageFetcher<GetTableVersionsResponse> {
        private GetTableVersionsResponseFetcher() {
        }

        public boolean hasNextPage(GetTableVersionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetTableVersionsResponse nextPage(GetTableVersionsResponse previousPage) {
            if (previousPage == null) {
                return GetTableVersionsIterable.this.client.getTableVersions(GetTableVersionsIterable.this.firstRequest);
            }
            return GetTableVersionsIterable.this.client.getTableVersions((GetTableVersionsRequest)((Object)GetTableVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

