/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsResponse;

public class GetPartitionsPublisher
implements SdkPublisher<GetPartitionsResponse> {
    private final GlueAsyncClient client;
    private final GetPartitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetPartitionsPublisher(GlueAsyncClient client, GetPartitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetPartitionsPublisher(GlueAsyncClient client, GetPartitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetPartitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetPartitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final GetPartitionsPublisher resume(GetPartitionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetPartitionsPublisher(this.client, (GetPartitionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetPartitionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetPartitionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetPartitionsResponseFetcher
    implements AsyncPageFetcher<GetPartitionsResponse> {
        private GetPartitionsResponseFetcher() {
        }

        public boolean hasNextPage(GetPartitionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<GetPartitionsResponse> nextPage(GetPartitionsResponse previousPage) {
            if (previousPage == null) {
                return GetPartitionsPublisher.this.client.getPartitions(GetPartitionsPublisher.this.firstRequest);
            }
            return GetPartitionsPublisher.this.client.getPartitions((GetPartitionsRequest)((Object)GetPartitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

